//Plot Magnitude Response of L.P.F .
//FIR filter design using Windowing Method- Kaiser Window
//OS:Windows 10
//Scilab 6.0.0

clear ;
clc ;
close ;

wsf = input("Enter the value of wsf in rad/sec");
ws = input("Enter the value of ws in rad/sec");
wp = input("Enter the value of wp in rad/sec");
as = input("Enter the value of as in dB");
ap = input("Enter the value of ap in dB");

B=ws -wp;
wc =0.5*(ws+wp);
wc1 =wc*2*%pi/ wsf ;
delta1 =10^(-0.05* as);
delta2 =(10^(0.05* as) -1)/(10^(0.05* as)+1);
delta = min(delta1,delta2);
alphas = -20*log10(delta);
alpha =0.5842*(alphas -21)^0.4+0.07886*(alphas -21)
D=(alphas -7.95)/14.36;
N1=wsf*D/B +1;
N= ceil(N1);
U= ceil(N/2) ;
win_l = window('kr',N,alpha);
for n=- floor(N/2)+U :1: floor(N/2) +U
    if n== ceil(N /2) ;
        hd(n) =0.5;
    else
        hd(n)=(sin(%pi*(n-U)/2))/(%pi*(n-U));
    end
    h(n)=hd(n)* win_l(n);
end
[hzm,fr]=frmag(h,256) ;
hzm_dB = 20*log10(hzm)./max(hzm);
figure
plot(2*fr,hzm_dB )
a= gca();
xlabel('Frequency w*pi ');
ylabel('Magnitude in dB ');
title('Frequency Response of LPF');
xgrid(2);
disp(h,"Filter Co efficients , h(n)=");

//Example Input
//Enter the value of wsf in rad/sec 100
//Enter the value of ws in rad/sec 30
//Enter the value of wp in rad/sec 20
//Enter the value of as in dB 44
//Enter the value of ap in dB 0.1
//Filter Co efficients , h(n)=
//   0.002441  -3.172D-18  -0.0068491   6.235D-18   0.0145007  -9.826D-18  -0.027237   1.347D-17    0.0494369  -1.661D-17  -0.0970495   1.874D-17   0.3152014   0.5   0.3152014   1.874D-17 -0.0970495  -1.661D-17   0.0494369   1.347D-17  -0.027237  -9.826D-18   0.0145007   6.235D-18  -0.0068491  -3.172D-18   0.002441
